<?php



// Get the invoice ID from the URL

$invoice_id = isset($_GET['invoiceID']) ? $_GET['invoiceID'] : null;



// Check if invoice ID is provided

if (!$invoice_id) {

    echo "Invoice ID is required.";

    exit;

}



// API URL

$api_url = "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/invoicepdfdata-api.php";



// Initialize cURL

$ch = curl_init();



// Set cURL options

curl_setopt($ch, CURLOPT_URL, $api_url . "?invoiceID=" . urlencode($invoice_id));

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

curl_setopt($ch, CURLOPT_HTTPGET, true);



// Execute the request

$response = curl_exec($ch);



// Check for cURL errors

if (curl_errno($ch)) {

    echo "Failed to fetch data from API: " . curl_error($ch);

    curl_close($ch);

    exit;

}



// Close cURL

curl_close($ch);



// Decode the JSON response

$data = json_decode($response, true);



// Check if JSON decoding was successful

if (json_last_error() !== JSON_ERROR_NONE) {

    echo "Failed to decode API response: " . json_last_error_msg();

    exit;

}



// Extract profile and invoice data

$profile = $data['profile'];

$invoice_data = $data['invoice_data'];



$output = '

<!DOCTYPE html>

<html>

<head>

    <!-- Basic Page Info -->

    <meta charset="utf-8">

    <title>Hapi Billz</title>



    <!-- Site favicon -->

    <link rel="apple-touch-icon" sizes="180x180" href="HB Short.png">

    <link rel="icon" type="image/png" sizes="32x32" href="HB Short.png">

    <link rel="icon" type="image/png" sizes="16x16" href="HB Short.png"> 



    <!-- Mobile Specific Metas -->

    <meta name="viewport" content="width=device-width, initial-scale=1.0">



    <!-- Google Font -->

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- CSS -->

    <link rel="stylesheet" type="text/css" href="vendors/styles/core.css">

    <link rel="stylesheet" type="text/css" href="vendors/styles/icon-font.min.css">

    <link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/responsive.bootstrap4.min.css">

    <link rel="stylesheet" type="text/css" href="vendors/styles/style.css">

    <link rel="stylesheet" href="invoicepdf/style.css" />

    

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

    <!-- Global site tag (gtag.js) - Google Analytics -->

    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-119386393-1"></script>

    <script>

        window.dataLayer = window.dataLayer || [];

        function gtag(){dataLayer.push(arguments);}

        gtag(\'js\', new Date());

        gtag(\'config\', \'UA-119386393-1\');

    </script>

    <style>

    

.invoice_style9 .invoice-table th {

//background: -webkit-linear-gradient(top, #01b3f2 0%, #6327ed 100%);

 // background: linear-gradient(180deg, #01b3f2 0%, #6327ed 100%);

}

  .invoice_style9 .footer-info {

  position: absolute;

  bottom: 0;

  left: 50px;

  width: calc(100% - 100px);

//background-image: -webkit-linear-gradient(top, #01b3f2 0%, #6327ed 100%);

  //background-image: linear-gradient(180deg, #01b3f2 0%, #6327ed 100%);

  border-radius: 100px 100px 0px 0px;

  display: -webkit-box;

  display: -webkit-flex;

  display: -ms-flexbox;

  display: flex;

  -webkit-box-align: center;

  -webkit-align-items: center;

  -ms-flex-align: center;

  align-items: center;

  -webkit-box-pack: justify;

  -webkit-justify-content: space-between;

  -ms-flex-pack: justify;

  justify-content: space-between;

  padding: 15px 50px;

  z-index: -2;

}

    </style>

    

    

    

    <script>

function getUrlParameter(name) {

    name = name.replace(/[\[\]]/g, "\\$&");

    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)");

    var results = regex.exec(window.location.href);

    if (!results) return null;

    if (!results[2]) return "";

    return decodeURIComponent(results[2].replace(/\+/g, " "));

}



function darkenColor(color, percent) {

    // Remove # if present and ensure valid hex

    color = color.replace("#", "");

    if (!/^[0-9A-F]{6}$/i.test(color)) return "#" + color;

    

    // Convert to RGB

    var r = parseInt(color.substring(0, 2), 16);

    var g = parseInt(color.substring(2, 4), 16);

    var b = parseInt(color.substring(4, 6), 16);



    // Darken each component (fixed missing parentheses)

    r = Math.max(0, Math.floor(r * (100 - percent) / 100));

    g = Math.max(0, Math.floor(g * (100 - percent) / 100));

    b = Math.max(0, Math.floor(b * (100 - percent) / 100));



    // Convert back to hex

     return "#" + r.toString(16).padStart(2, "0") +

                 g.toString(16).padStart(2, "0") +

                 b.toString(16).padStart(2, "0");

}



function lightenColor(color, percent) {

    color = color.replace("#", "");

    if (!/^[0-9A-F]{6}$/i.test(color)) return "#" + color;

    var r = parseInt(color.substring(0, 2), 16);

    var g = parseInt(color.substring(2, 4), 16);

    var b = parseInt(color.substring(4, 6), 16);

    r = Math.min(255, Math.floor(r + (255 - r) * (percent / 100)));

    g = Math.min(255, Math.floor(g + (255 - g) * (percent / 100)));

    b = Math.min(255, Math.floor(b + (255 - b) * (percent / 100)));

     return "#" + r.toString(16).padStart(2, "0") +

                 g.toString(16).padStart(2, "0") +

                 b.toString(16).padStart(2, "0");

}



function getClosestColorName(hex) {

    const namedColors = {

        "Red": "#ff0000",

        "Blue": "#0000ff",

        "Green": "#00ff00",

        "Pink": "#ffc0cb",

        "Black": "#000000",

        "Orange": "#ffa500",

        "Violet": "#8f00ff",

        "Yellow": "#ffff00"

    };



    function colorDistance(hex1, hex2) {

        const r1 = parseInt(hex1.substr(1, 2), 16);

        const g1 = parseInt(hex1.substr(3, 2), 16);

        const b1 = parseInt(hex1.substr(5, 2), 16);



        const r2 = parseInt(hex2.substr(1, 2), 16);

        const g2 = parseInt(hex2.substr(3, 2), 16);

        const b2 = parseInt(hex2.substr(5, 2), 16);



        return Math.sqrt(

            (r1 - r2) ** 2 +

            (g1 - g2) ** 2 +

            (b1 - b2) ** 2

        );

    }



    let closestColor = "hosting_bg";

    let minDistance = Infinity;



    for (const [name, code] of Object.entries(namedColors)) {

        const distance = colorDistance(hex.toLowerCase(), code.toLowerCase());

        if (distance < minDistance) {

            minDistance = distance;

            closestColor = name;

        }

    }



    return closestColor;

}





var invoiceID = getUrlParameter("invoiceID");



if (invoiceID) {

    $.ajax({

        url: "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/template-api.php?invoiceID=" + invoiceID,

        type: "GET",

        dataType: "json",

        success: function(response) {

            if (response.success && response["colour code"]) {

                var baseColor = response["colour code"].trim().toLowerCase();

                var darkColor = darkenColor(baseColor, 10);    // 20% darker

                var lightColor = lightenColor(baseColor, 40);  // 20% lighter

				//  var darkColor = colorCode === "#01b3f2" ? "#6327ed" : darkenColor(colorCode, 20);

                

                 var gradientStyles = `

                    .invoice_style9 .invoice-table th {

                        background: linear-gradient(180deg, ${darkColor} 0%, ${lightColor} 100%);

                    }

                    .invoice_style9 .footer-info {

                        background-image: linear-gradient(180deg, ${darkColor} 0%, ${lightColor} 100%);

                    }

                `;

                

                var styleElement = document.createElement("style");

                styleElement.innerHTML = gradientStyles;

                document.head.appendChild(styleElement);

                

                

                

                // ✅ Dynamically choose background image

                let colorName = getClosestColorName(baseColor);

                let imageFile = `invoicepdf/${colorName}.jpg`;

                

                const invoiceElement = document.querySelector(".th-invoice.invoice_style9");

                if (invoiceElement) {

                    invoiceElement.style.backgroundImage = `url(${imageFile})`;

                    invoiceElement.style.backgroundSize = "100% 100%";

                    invoiceElement.style.backgroundRepeat = "no-repeat";

                    

                     const downloadSection = document.getElementById("download_section");

    if (downloadSection) {

        downloadSection.setAttribute("data-color", baseColor);

        downloadSection.setAttribute("data-dark-color", darkColor);

        downloadSection.setAttribute("data-light-color", lightColor);

        downloadSection.setAttribute("data-bg-image", imageFile);

    }

                }





            }

        },

        error: function(xhr, status, error) {

            console.error("Error fetching template data:", error);

        }

    });

}

    </script>









</head>

<body class="hosting-template">

    <div class="invoice-container-wrap">

      <div class="invoice-container">

        <main>

          <div class="th-invoice invoice_style9" style="background-image: url(invoicepdf/hosting_bg.png);

    background-repeat: no-repeat;

    background-size: 100% 100%;

    background-position: top;

    position: relative;

    z-index: 1;

    ">

            <div class="download-inner" id="download_section">

              <header class="th-header header-layout4">

                <div class="row justify-content-between">

                  <div class="col-6" style="">

                    <div class="header-logo">

                      <a href="index.html"><img src="'.htmlspecialchars($profile['logopath']).'" alt="Invar"/></a>

                    </div>

                  </div>

                  <div class="col-6 text-right">

                    <h1 class="big-title" style="opacity: 0.1;">Invoice</h1>

                    <p class="invoice-number text-title-1">'. htmlspecialchars($profile['storename']) . '</p>

                    <p class="invoice-number">'. htmlspecialchars($profile['email']) . '</p>

                    <p class="invoice-number">  

                        '. htmlspecialchars($profile['street1']) .', <br/>

                        ' . htmlspecialchars($profile['street2']) .',<br/>

                        '. htmlspecialchars($profile['city']) .', <br/>

                        '. htmlspecialchars($profile['pincode']) .' </p>

                    <p class="invoice-number"> +91 ' . htmlspecialchars($profile['phonenumber']) .'</p>

                  </div>

                </div>

              </header>

              <div class="row justify-content-between mt-5 mb-30">

                <div class="col-6">

                  <div class="invoice-left">

                    <table>

                      <tr>

                        <td><b>Invoice No</b></td>

                        <td>:</td>

                        <td style="color: #000">#'.htmlspecialchars($profile['invoiceno']).'</td>

                      </tr>

                      <tr>

                        <td>Order No</td>

                        <td>:</td>

                        <td>'.$profile['orderid'].'</td>

                      </tr>

                      <tr>

                        <td>Invoice Date</td>

                        <td>:</td>

                        <td>'.htmlspecialchars($profile['invoicedate']).'</td>

                      </tr>

                      <tr>

                        <td>Due Date</td>

                        <td>:</td>

                        <td>01/04/2025</td>

                      </tr>

                    </table>

                  </div>

                </div>

                <div class="col-6">

                  <div class="invoice-right">

                    <b>Shipping Address:</b>

                    <address>

                      '. htmlspecialchars($profile['displayname']) .'<br>

                      '. htmlspecialchars($profile['address']) .','. htmlspecialchars($profile['address2']).',<br>

                      '. htmlspecialchars($profile['customer_city']) .', <br/>

                      Pin:'. htmlspecialchars($profile['customer_pincode']) .'<br>

                      '.htmlspecialchars($profile['customer_email']) .'            

                    </address>

                  </div>

                </div>

              </div>

              <p class="table-title text-center"><b>Customer Info:</b></p>

              <table class="invoice-table style4">

                <thead>

                  <tr>

                    <th>Name:</th>

                    <th>Phone:</th>

                    <th>GST :</th>

                  </tr>

                </thead>

                <tbody>

                  <tr>

                    <td>'. htmlspecialchars($profile['displayname']) .'</td>

                    <td>+91 '. htmlspecialchars($profile['phoneno']) .'</td>

                    <td>'. htmlspecialchars($profile['customer_gstno']) .'</td>

                  </tr>

                  <tr>

                    <td colspan="3" class="bg-white">

                      <b>Address:</b>

                      '. htmlspecialchars($profile['address']) .','. htmlspecialchars($profile['address2']).','. htmlspecialchars($profile['customer_city']) .'</td>

                  </tr>

                </tbody>

              </table>

              <table class="invoice-table table-stripe-column">

                <thead>

                  <tr>

                    <th>S.No</th>

                    <th>Items</th>

                    <th style="width: 1%;">QTY</th>

                    <th>Rate</th>

                    <th style="width: 1%;">Tax</th>

                    <th>Amount</th>

                  </tr>

                </thead>';

                

                $count = 0;

                $productsPerPage = 25;

                $totalsavings = htmlspecialchars($profile['totalsavings']);

                $grandtotal = htmlspecialchars($profile['grandtotal']);

                $balance = htmlspecialchars($data['due_amount']);

                $notes = htmlspecialchars($profile['notes']);

                $terms = htmlspecialchars($profile['terms']);

                $qrcode = $profile['qrcode'] ? $profile['qrcode'] : '';

                $accountno = htmlspecialchars($profile['account']);

                $ifsc = htmlspecialchars($profile['ifsc']);

                $bank = htmlspecialchars($profile['bankname']);

                $upiid = htmlspecialchars($profile['upiid']);

                

                foreach ($invoice_data as $item) {

                    $count++;

                    $output .= '

                <tbody>

                  <tr>

                    <td>' . $count . '</td>

                    <td>' . htmlspecialchars($item['Product_name']) . '</td>

                    <td>' . htmlspecialchars($item['Qty']) . '</td>

                    <td>₹' . htmlspecialchars($item['Selling_price']) . '</td>

                    <td>' . htmlspecialchars($item['Tax_percentage']) . '%</td>

                    <td>₹' . htmlspecialchars($item['Product_total']) . '</td>

                  </tr>';



                    // Check if it's time for a page break

                    if ($count % $productsPerPage == 0) {

                        $output .= '</tbody></table><div style="page-break-before:always;"></div><table class="table mb-0"><thead class="card-header"><tr><td class="col-3"><strong>S. NO</strong></td><td class="col-3"><strong>Item</strong></td><td class="col-4"><strong>Qty</strong></td><td class="col-1 text-center"><strong>Rate</strong></td><td class="col-2 text-end"><strong>Tax</strong></td><td class="col-2 text-end"><strong>Amount</strong></td></tr></thead><tbody>';

                    }

                }



                $tax_data = $data['taxvalue'];

                

                if ($tax_data != "") {

                    $output .= ' 

                </tbody>

                <tfoot>

                 <tr>

                    <td colspan="5"><b>Tax:</b></td>

                    <td>₹'.number_format($tax_data).'</td>

                  </tr>';

                }

                $output .= '

                  <!---<tr>

                    <td colspan="5"><b>Sub Total:</b></td>

                    <td>₹545.30</td>

                  </tr>--->

                  <tr>

                    <td colspan="5"><b>Discount:</b></td>

                    <td>₹'.$totalsavings.'.00</td>

                  </tr>

                  <tr>

                    <td colspan="5"><b>Total:</b></td>

                    <td>₹'.$grandtotal.'.00</td>

                  </tr>

                  <tr>

                    <td colspan="5"><b>Balance:</b></td>

                    <td>₹'.($balance > 1 ? $balance : $grandtotal).'.00</td>

                  </tr>

                </tfoot>

              </table>

              <div class="row justify-content-between" style="display: none;">

                <div class="col-auto">

                  <div class="invoice-left">

                    <b>Payment Info:</b>

                    <p class="mb-0">

                      Account : 1234 5678 9012<br />A/C Name : Alex Farnandes<br />

                    </p>

                  </div>

                </div>

                <div class="col-auto">

                  <table class="total-table3">

                    <tr>

                      <th>Paid:</th>

                      <td>₹545.00</td>

                    </tr>

                    <tr>

                      <th>Balance Due:</th>

                      <td>₹00.00</td>

                    </tr>

                  </table>

                </div>

              </div>

              <p class="invoice-note mt-3">

                <b>Terms & Conditions: </b>'.$terms.'

              </p>

              <div class="footer-info">

                <p class="mb-0 f-text">

                  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">

                    <rect width="20" height="20" rx="4" fill="#01B3F2" />

                    <path d="M10 4.5C11.125 4.51562 12.1328 4.78906 13.0234 5.32031C13.9297 5.85156 14.6484 6.57031 15.1797 7.47656C15.7109 8.36719 15.9844 9.375 16 10.5C15.9844 11.625 15.7109 12.6328 15.1797 13.5234C14.6484 14.4297 13.9297 15.1484 13.0234 15.6797C12.1328 16.2109 11.125 16.4844 10 16.5C8.875 16.4844 7.86719 16.2109 6.97656 15.6797C6.07031 15.1484 5.35156 14.4297 4.82031 13.5234C4.28906 12.6328 4.01562 11.625 4 10.5C4.01562 9.375 4.28906 8.36719 4.82031 7.47656C5.35156 6.57031 6.07031 5.85156 6.97656 5.32031C7.86719 4.78906 8.875 4.51562 10 4.5ZM10 15.75C10.2031 15.75 10.4297 15.6484 10.6797 15.4453C10.9297 15.2422 11.1875 14.8984 11.4531 14.4141C11.6875 13.9297 11.8672 13.375 11.9922 12.75H7.98438C8.125 13.375 8.3125 13.9297 8.54688 14.4141C8.8125 14.8984 9.07031 15.2422 9.32031 15.4453C9.57031 15.6484 9.79688 15.75 10 15.75ZM7.84375 12H12.1562C12.2188 11.5312 12.25 11.0312 12.25 10.5C12.25 9.96875 12.2188 9.46875 12.1562 9H7.84375C7.78125 9.46875 7.75 9.96875 7.75 10.5C7.75 11.0312 7.78125 11.5312 7.84375 12ZM11.9922 8.25C11.8672 7.60938 11.6875 7.05469 11.4531 6.58594C11.1875 6.10156 10.9297 5.75781 10.6797 5.55469C10.4297 5.35156 10.2031 5.25 10 5.25C9.79688 5.25 9.57031 5.35156 9.32031 5.55469C9.07031 5.75781 8.8125 6.10156 8.54688 6.58594C8.3125 7.05469 8.125 7.60938 7.98438 8.25H11.9922ZM12.8828 9C12.9609 9.48438 13 9.98438 13 10.5C13 11.0156 12.9609 11.5156 12.8828 12H15.0391C15.1797 11.5156 15.25 11.0156 15.25 10.5C15.25 9.98438 15.1797 9.48438 15.0391 9H12.8828ZM11.6875 5.53125C12.1875 6.20312 12.5547 7.10938 12.7891 8.25H14.7344C14.4375 7.60938 14.0234 7.05469 13.4922 6.58594C12.9609 6.11719 12.3594 5.76562 11.6875 5.53125ZM8.33594 5.53125C7.64844 5.76562 7.03906 6.11719 6.50781 6.58594C5.97656 7.05469 5.5625 7.60938 5.26562 8.25H7.21094C7.44531 7.10938 7.82031 6.20312 8.33594 5.53125ZM4.75 10.5C4.75 11.0156 4.82031 11.5156 4.96094 12H7.09375C7.03125 11.5156 7 11.0156 7 10.5C7 9.98438 7.03125 9.48438 7.09375 9H4.96094C4.82031 9.48438 4.75 9.98438 4.75 10.5ZM14.7344 12.75H12.7891C12.5547 13.8906 12.1875 14.7969 11.6875 15.4688C12.3594 15.2344 12.9609 14.8828 13.4922 14.4141C14.0234 13.9453 14.4375 13.3906 14.7344 12.75ZM7.21094 12.75H5.26562C5.5625 13.3906 5.97656 13.9453 6.50781 14.4141C7.03906 14.8828 7.64844 15.2344 8.33594 15.4688C7.82031 14.7969 7.44531 13.8906 7.21094 12.75Z" fill="white"/>

                  </svg>

                  www.RF Ghee.com

                </p>

                <p class="mb-0 f-text">

                  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">

                    <rect width="20" height="20" rx="4" fill="#01B3F2" />

                    <path d="M15.25 12C15.5312 12.125 15.7344 12.3203 15.8594 12.5859C15.9844 12.8359 16.0156 13.1094 15.9531 13.4062L15.4609 15.5391C15.3984 15.8359 15.2578 16.0703 15.0391 16.2422C14.8203 16.4141 14.5703 16.5 14.2891 16.5C12.3672 16.4844 10.6328 16.0156 9.08594 15.0938C7.55469 14.1719 6.32812 12.9453 5.40625 11.4141C4.48438 9.86719 4.01562 8.13281 4 6.21094C4 5.92969 4.08594 5.67969 4.25781 5.46094C4.42969 5.24219 4.66406 5.09375 4.96094 5.01562L7.09375 4.52344C7.39062 4.46094 7.66406 4.5 7.91406 4.64062C8.17969 4.76562 8.375 4.96875 8.5 5.25L9.48438 7.57031C9.59375 7.82031 9.61719 8.07812 9.55469 8.34375C9.49219 8.60938 9.35156 8.82812 9.13281 9L8.33594 9.65625C8.96094 10.7031 9.80469 11.5391 10.8672 12.1641L11.5234 11.3672C11.6953 11.1484 11.9141 11.0078 12.1797 10.9453C12.4453 10.8828 12.7031 10.9062 12.9531 11.0156L15.25 12ZM14.875 13.1484C14.875 13.1016 14.8516 13.0547 14.8047 13.0078L12.5078 12.0234C12.4609 12.0078 12.4219 12.0234 12.3906 12.0703L11.4531 13.1953C11.25 13.4141 11.0234 13.4688 10.7734 13.3594C9.97656 12.9688 9.26562 12.4609 8.64062 11.8359C8.03125 11.2109 7.52344 10.5 7.11719 9.70312C7.00781 9.4375 7.0625 9.21094 7.28125 9.02344L8.42969 8.10938C8.46094 8.07812 8.46875 8.03906 8.45312 7.99219L7.46875 5.69531C7.4375 5.64844 7.40625 5.625 7.375 5.625C7.35938 5.625 7.35156 5.625 7.35156 5.625L5.19531 6.11719C5.14844 6.13281 5.125 6.16406 5.125 6.21094C5.14062 7.91406 5.55469 9.45312 6.36719 10.8281C7.19531 12.2031 8.29688 13.3047 9.67188 14.1328C11.0469 14.9453 12.5859 15.3594 14.2891 15.375C14.3359 15.3594 14.3672 15.3359 14.3828 15.3047L14.875 13.1484Z" fill="white"/>

                  </svg>

                  +91 ' . htmlspecialchars($profile['phonenumber']) .'

                </p>

                <p class="mb-0 f-text">

                  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">

                    <rect width="20" height="20" rx="4" fill="#01B3F2" />

                    <path d="M4 7.5C4.01562 7.07812 4.16406 6.72656 4.44531 6.44531C4.72656 6.16406 5.07812 6.01562 5.5 6H14.5C14.9219 6.01562 15.2734 6.16406 15.5547 6.44531C15.8359 6.72656 15.9844 7.07812 16 7.5V13.5C15.9844 13.9219 15.8359 14.2734 15.5547 14.5547C15.2734 14.8359 14.9219 14.9844 14.5 15H5.5C5.07812 14.9844 4.72656 14.8359 4.44531 14.5547C4.16406 14.2734 4.01562 13.9219 4 13.5V7.5ZM5.125 7.5V8.01562L9.17969 11.3438C9.42969 11.5312 9.70312 11.625 10 11.625C10.2969 11.625 10.5781 11.5312 10.8438 11.3438L14.875 8.01562V7.47656C14.8594 7.25781 14.7344 7.13281 14.5 7.10156H5.5C5.26562 7.13281 5.14062 7.25781 5.125 7.47656V7.5ZM5.125 9.46875V13.5C5.14062 13.7344 5.26562 13.8594 5.5 13.875H14.5C14.7344 13.8594 14.8594 13.7344 14.875 13.5V9.46875L11.5469 12.2109C11.0781 12.5703 10.5625 12.75 10 12.75C9.4375 12.75 8.91406 12.5703 8.42969 12.2109L5.125 9.46875Z" fill="white"/>

                  </svg>

                  '. htmlspecialchars($profile['email']) . '

                </p>

              </div>

            </div>

            <div class="invoice-buttons">

              <button onclick="window.print()" class="print_btn">

                <svg

                  width="20"

                  height="21"

                  viewBox="0 0 20 21"

                  fill="none"

                  xmlns="http://www.w3.org/2000/svg"

                >

                  <path

                    d="M16.25 13C16.6146 13 16.9141 13.1172 17.1484 13.3516C17.3828 13.5859 17.5 13.8854 17.5 14.25V19.25C17.5 19.6146 17.3828 19.9141 17.1484 20.1484C16.9141 20.3828 16.6146 20.5 16.25 20.5H3.75C3.38542 20.5 3.08594 20.3828 2.85156 20.1484C2.61719 19.9141 2.5 19.6146 2.5 19.25V14.25C2.5 13.8854 2.61719 13.5859 2.85156 13.3516C3.08594 13.1172 3.38542 13 3.75 13H16.25ZM16.25 19.25V14.25H3.75V19.25H16.25ZM17.5 8C18.2031 8.02604 18.7891 8.27344 19.2578 8.74219C19.7266 9.21094 19.974 9.79688 20 10.5V14.875C19.974 15.2656 19.7656 15.474 19.375 15.5C18.9844 15.474 18.776 15.2656 18.75 14.875V10.5C18.75 10.1354 18.6328 9.83594 18.3984 9.60156C18.1641 9.36719 17.8646 9.25 17.5 9.25H2.5C2.13542 9.25 1.83594 9.36719 1.60156 9.60156C1.36719 9.83594 1.25 10.1354 1.25 10.5V14.875C1.22396 15.2656 1.01562 15.474 0.625 15.5C0.234375 15.474 0.0260417 15.2656 0 14.875V10.5C0.0260417 9.79688 0.273438 9.21094 0.742188 8.74219C1.21094 8.27344 1.79688 8.02604 2.5 8V3C2.52604 2.29688 2.77344 1.71094 3.24219 1.24219C3.71094 0.773438 4.29688 0.526042 5 0.5H14.7266C15.0651 0.5 15.3646 0.617188 15.625 0.851562L17.1484 2.375C17.3828 2.60938 17.5 2.90885 17.5 3.27344V8ZM16.25 8V3.27344L14.7266 1.75H5C4.63542 1.75 4.33594 1.86719 4.10156 2.10156C3.86719 2.33594 3.75 2.63542 3.75 3V8H16.25ZM16.875 10.1875C17.4479 10.2396 17.7604 10.5521 17.8125 11.125C17.7604 11.6979 17.4479 12.0104 16.875 12.0625C16.3021 12.0104 15.9896 11.6979 15.9375 11.125C15.9896 10.5521 16.3021 10.2396 16.875 10.1875Z"

                    fill="#111111"

                  />

                </svg>

              </button>

              <button id="download_btn" class="download_btn">

                <svg

                  width="25"

                  height="19"

                  viewBox="0 0 25 19"

                  fill="none"

                  xmlns="http://www.w3.org/2000/svg"

                >

                  <path

                    d="M8.94531 11.1797C8.6849 10.8932 8.6849 10.6068 8.94531 10.3203C9.23177 10.0599 9.51823 10.0599 9.80469 10.3203L11.875 12.3516V6.375C11.901 5.98438 12.1094 5.77604 12.5 5.75C12.8906 5.77604 13.099 5.98438 13.125 6.375V12.3516L15.1953 10.3203C15.4818 10.0599 15.7682 10.0599 16.0547 10.3203C16.3151 10.6068 16.3151 10.8932 16.0547 11.1797L12.9297 14.3047C12.6432 14.5651 12.3568 14.5651 12.0703 14.3047L8.94531 11.1797ZM10.625 0.75C11.7969 0.75 12.8646 1.01042 13.8281 1.53125C14.8177 2.05208 15.625 2.76823 16.25 3.67969C16.8229 3.39323 17.4479 3.25 18.125 3.25C19.375 3.27604 20.4036 3.70573 21.2109 4.53906C22.0443 5.34635 22.474 6.375 22.5 7.625C22.5 8.01562 22.4479 8.41927 22.3438 8.83594C23.151 9.2526 23.7891 9.85156 24.2578 10.6328C24.7526 11.4141 25 12.2865 25 13.25C24.974 14.6562 24.4922 15.8411 23.5547 16.8047C22.5911 17.7422 21.4062 18.224 20 18.25H5.625C4.03646 18.1979 2.70833 17.651 1.64062 16.6094C0.598958 15.5417 0.0520833 14.2135 0 12.625C0.0260417 11.375 0.377604 10.2812 1.05469 9.34375C1.73177 8.40625 2.63021 7.72917 3.75 7.3125C3.88021 5.4375 4.58333 3.88802 5.85938 2.66406C7.13542 1.4401 8.72396 0.802083 10.625 0.75ZM10.625 2C9.08854 2.02604 7.78646 2.54688 6.71875 3.5625C5.67708 4.57812 5.10417 5.85417 5 7.39062C4.94792 7.91146 4.67448 8.27604 4.17969 8.48438C3.29427 8.79688 2.59115 9.33073 2.07031 10.0859C1.54948 10.8151 1.27604 11.6615 1.25 12.625C1.27604 13.875 1.70573 14.9036 2.53906 15.7109C3.34635 16.5443 4.375 16.974 5.625 17H20C21.0677 16.974 21.9531 16.6094 22.6562 15.9062C23.3594 15.2031 23.724 14.3177 23.75 13.25C23.75 12.5208 23.5677 11.8698 23.2031 11.2969C22.8385 10.724 22.3568 10.2682 21.7578 9.92969C21.2109 9.59115 21.0026 9.09635 21.1328 8.44531C21.2109 8.21094 21.25 7.9375 21.25 7.625C21.224 6.73958 20.9245 5.9974 20.3516 5.39844C19.7526 4.82552 19.0104 4.52604 18.125 4.5C17.6302 4.5 17.1875 4.60417 16.7969 4.8125C16.1719 5.04688 15.651 4.90365 15.2344 4.38281C14.7135 3.65365 14.0495 3.08073 13.2422 2.66406C12.4609 2.22135 11.5885 2 10.625 2Z"

                    fill="white"

                  />

                </svg>

              </button>

            </div>

          </div>

        </main>

      </div>

    </div>

    <script src="invoicepdf/jquery-3.6.0.min.js"></script>

    <script src="invoicepdf/app.min.js"></script>

    <script src="invoicepdf/main.js"></script>





   

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>



	

	

	</body> 

	





</html>';



// Output the final HTML

echo $output;

?>